/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon;

import com.quantumdata.busmon.ConnectDialog;
import com.quantumdata.busmon.ExtensionFilter;
import com.quantumdata.busmon.FindDialog;
import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.SendCommandDialog;
import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.parser.BadPacketException;
import com.quantumdata.busmon.parser.CECDataBlock;
import com.quantumdata.busmon.parser.DPCDDataBlock;
import com.quantumdata.busmon.parser.I2CDataBlock;
import com.quantumdata.busmon.parser.I2CMessage;
import com.quantumdata.busmon.parser.PacketTrace;
import com.quantumdata.busmon.parser.Parser;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

class CommandAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final String sEDIDFilesPathName = "C:\\";
    private static final String sSaveDialogTitle = "Save EDID to XML File";
    private Command aCommand;

    CommandAction(String string, Command command) {
        super(string);
        this.aCommand = command;
    }

    CommandAction(String string, Command command, KeyStroke keyStroke, int n) {
        this(string, command);
        if (keyStroke != null) {
            this.putValue("AcceleratorKey", keyStroke);
        }
        if (n != 0) {
            this.putValue("MnemonicKey", n);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        switch (this.aCommand) {
            case CONNECT: {
                ConnectDialog connectDialog = new ConnectDialog((Frame)Sniffer.window, true);
                connectDialog.setVisible(true);
                break;
            }
            case NEW: {
                if (MainAppFrame.confirmNewAction.isTrue() && Parser.packets.needsSaving()) break;
                Parser.packets.clear();
                I2CDataBlock.resetParser();
                CECDataBlock.resetParser();
                DPCDDataBlock.resetParser();
                MainAppFrame.deltaTimeStartIndex = -1;
                MainAppFrame.openFile = null;
                MainAppFrame.saveAction.setEnabled(false);
                I2CMessage.resetEDID();
                break;
            }
            case OPEN: {
                PacketTrace packetTrace;
                if (MainAppFrame.confirmNewAction.isTrue() && Parser.packets.needsSaving()) {
                    return;
                }
                File file = MainAppFrame.showFileDialog("Open Trace File", "Open", "Read a trace from a saved file", ".BMtrace", "Bus Monitor Trace files (*.BMtrace)", null);
                if (file == null) break;
                ObjectInputStream objectInputStream = null;
                try {
                    I2CMessage.resetEDID();
                    objectInputStream = new ObjectInputStream(new FileInputStream(file));
                    packetTrace = new PacketTrace(objectInputStream);
                    objectInputStream.close();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JOptionPane.showMessageDialog(Sniffer.window, "This file does not appear to be a trace file, is from an older version of the application, or is corrupted.");
                    break;
                }
                catch (BadPacketException badPacketException) {
                    JOptionPane.showMessageDialog(Sniffer.window, "Error Reading Packet Trace File\n" + badPacketException.getMessage());
                    break;
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(Sniffer.window, "There was an I/O error while attempting to read the trace file: " + iOException.getMessage());
                    break;
                }
                MainAppFrame.openFile = file;
                Parser.packets = packetTrace;
                Sniffer.window.setUpPacketTable();
                MainAppFrame.saveAction.setEnabled(true);
                break;
            }
            case SAVE: {
                this.saveTrace();
                break;
            }
            case SAVEAS: {
                this.saveTraceAs();
                break;
            }
            case SAVETOHTML: {
                this.saveToHtml();
                break;
            }
            case SAVEEDIDFROMTRACE: {
                CommandAction.saveEDIDsToFiles();
                break;
            }
            case QUIT: {
                if (MainAppFrame.confirmExitAction.isTrue() && Parser.packets.needsSaving()) {
                    MainAppFrame.saveAsAction.saveTraceAs();
                }
                System.exit(0);
                break;
            }
            case FIND: {
                if (MainAppFrame.findDialog == null) {
                    MainAppFrame.findDialog = new FindDialog((Frame)Sniffer.window, false);
                }
                MainAppFrame.findDialog.setVisible(true);
                break;
            }
            case FINDNEXT: {
                if (MainAppFrame.findDialog == null) {
                    MainAppFrame.findDialog = new FindDialog((Frame)Sniffer.window, false);
                    MainAppFrame.findDialog.setVisible(true);
                    break;
                }
                ((FindDialog)MainAppFrame.findDialog).findNext();
                break;
            }
            case SENDCOMMAND: {
                if (MainAppFrame.sendCommandDialog == null) {
                    MainAppFrame.sendCommandDialog = new SendCommandDialog((Frame)Sniffer.window, false);
                }
                MainAppFrame.sendCommandDialog.setVisible(true);
                break;
            }
            case COLORS: {
                break;
            }
            case ABOUT: {
                String string = String.format("Quantum Data Auxiliary Channel Analyzer\nVersion %d.%d (Trace File Format Version %d.%d)\n\nCopyright (c) 2006 by Quantum Data.  All rights reserved.", 1, 12, 2, 7);
                JOptionPane.showMessageDialog(Sniffer.window, string);
                break;
            }
        }
    }

    public void saveTrace() {
        int n;
        File file = MainAppFrame.openFile;
        if (file.exists() && (n = JOptionPane.showConfirmDialog(Sniffer.window, file.getName() + " exists.  Overwrite?", "Confirm Save", 0, 2)) != 1) {
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                Parser.packets.writeTrace(objectOutputStream);
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(Sniffer.window, "There was an I/O error while attempting to save the trace: " + iOException.getMessage());
            }
        }
    }

    public void saveTraceAs() {
        boolean bl = true;
        File file = MainAppFrame.openFile;
        if (file == null) {
            file = MainAppFrame.showFileDialog("Save Trace", "Save", "Save the trace", ".BMtrace", "Bus Monitor Trace files (*.BMtrace)", new File(MainAppFrame.files.getCurrentDirectory(), MainAppFrame.getTraceFilename()));
        } else if (file.exists()) {
            file = MainAppFrame.showFileDialog("Save Trace", "Save", "Save the trace", ".BMtrace", "Bus Monitor Trace files (*.BMtrace)", new File(MainAppFrame.files.getCurrentDirectory(), MainAppFrame.getCurrentTraceFilename()));
        }
        if (file != null) {
            if (!file.getName().endsWith(".BMtrace")) {
                file = new File(file.getAbsolutePath() + ".BMtrace");
            }
            if (file.exists() && 1 == JOptionPane.showConfirmDialog(Sniffer.window, file.getName() + " exists.  Overwrite?", "Confirm Save", 0, 2)) {
                bl = false;
            }
        }
        if (bl) {
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                Parser.packets.writeTrace(objectOutputStream);
                objectOutputStream.close();
                MainAppFrame.openFile = file;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(Sniffer.window, "There was an I/O error while attempting to save the trace: " + iOException.getMessage());
            }
        }
    }

    public void saveToHtml() {
        boolean bl = true;
        File file = MainAppFrame.openFile;
        file = MainAppFrame.showFileDialog("Save To HTML", "Save", "Save the table to HTML", ".html", "HTML files (.html)", new File(MainAppFrame.files.getCurrentDirectory(), MainAppFrame.getHtmlFilename()));
        if (file.exists() && 1 == JOptionPane.showConfirmDialog(Sniffer.window, file.getName() + " exists.  Overwrite?", "Confirm Save", 0, 2)) {
            bl = false;
        }
        if (bl) {
            Sniffer.window.saveToHTML(file);
        }
    }

    private static void saveEDIDsToFiles() {
        String string = "EDID.xml";
        File file = CommandAction.showSaveEDIDXMLDialog("Save EDID", "Save", sSaveDialogTitle, ".xml", "EDID XML Files (*.xml)", new File(sEDIDFilesPathName, string));
        if (file != null) {
            I2CMessage.writeXMLEDID(file);
        }
    }

    private static File showSaveEDIDXMLDialog(String string, String string2, String string3, String string4, String string5, File file) {
        File file2 = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(string);
        jFileChooser.setApproveButtonText(string2);
        jFileChooser.setApproveButtonToolTipText(string3);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.resetChoosableFileFilters();
        ExtensionFilter extensionFilter = new ExtensionFilter(string4, string5);
        jFileChooser.addChoosableFileFilter(extensionFilter);
        jFileChooser.setFileFilter(extensionFilter);
        jFileChooser.rescanCurrentDirectory();
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showDialog(Sniffer.window, null);
        if (n == 0) {
            file2 = jFileChooser.getSelectedFile();
        }
        return file2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        CONNECT,
        NEW,
        OPEN,
        SAVEAS,
        QUIT,
        FIND,
        FINDNEXT,
        SENDCOMMAND,
        ABOUT,
        COLORS,
        SAVETOHTML,
        SAVEEDIDFROMTRACE,
        SAVE;

    }
}

